#!/bin/bash
export datasets="wikics cs"
export missing_rates="0.0 0.1"
export lambda_list_1="0.00001"
export lambda_list_2="0.00001 0.0001 0.001 0.01 0.1 1 10"
export lp_alpha_list="0.9 0.99 0.999 0.9999"
export embedders="GNN"
export embedder_lp_list="GCN_LPA Correct_Smooth"
export gpu=0

for lamb in $lambda_list_2
do
for missing_rate in $missing_rates
do
python main.py --dataset Cora --lp_alpha 0.99 --missing_rate ${missing_rate} --lamb ${lamb} --embedder GOODIE_2 --n_runs 3 --missing_type uniform --gpu ${gpu}
python main.py --dataset CiteSeer --lp_alpha 0.999 --missing_rate ${missing_rate} --lamb ${lamb} --embedder GOODIE_2 --n_runs 3 --missing_type uniform --gpu ${gpu}
python main.py --dataset wikics --lp_alpha 0.9 --missing_rate ${missing_rate} --lamb ${lamb} --embedder GOODIE_2 --n_runs 3 --missing_type uniform --gpu ${gpu}
python main.py --dataset cs --lp_alpha 0.99 --missing_rate ${missing_rate} --lamb ${lamb} --embedder GOODIE_2 --n_runs 3 --missing_type uniform --gpu ${gpu}
done
done

for lamb in $lambda_list_2
do
for missing_rate in $missing_rates
do
python main.py --dataset PubMed --lp_alpha 0.999 --missing_rate ${missing_rate} --lamb ${lamb} --embedder GOODIE_2 --n_runs 3 --missing_type uniform --gpu ${gpu}
done
done
